﻿using System;
using System.IO;
using System.Net;

class FtpPut
{
    static void Main()
    {
        string ftpDest = "ftp://www.myftpsite.com/MyFile.txt";
        string fileSource = "MyFile.txt";
        string userName = "nazwa_użytkownika";
        string password = "hasło";

        FtpWebRequest request = 
            WebRequest.Create(ftpDest) 
            as FtpWebRequest;
        request.Method = 
            WebRequestMethods.Ftp.UploadFile;

        request.Credentials = 
            new NetworkCredential(userName, password);

        using (Stream requestStream = 
            request.GetRequestStream())
        {
            const int bufferLength = 2048;
            var buffer = new byte[bufferLength];
            int count = 0;
            int readBytes = 0;

            using (FileStream stream = 
                File.OpenRead(fileSource))
            {
                do
                {
                    readBytes = stream.Read(
                        buffer, 0, bufferLength);
                    requestStream.Write(
                        buffer, 0, readBytes);
                    count += readBytes;
                }
                while (readBytes != 0);
            }

            request.ContentLength = count;
        }

        using (FtpWebResponse response = 
            request.GetResponse() 
            as FtpWebResponse)
        {
            Console.WriteLine(
                "Przesyłanie pliku zakończone, status {0}", 
                response.StatusDescription);
        }
    }
}
